%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Plot a nice image --- %    

[height position]                           = hist(reshape(images(:,:,j),size(images,1)*size(images,2),1),256);        
max_z_hist                                  = max(position);
min_z_hist                                  = min(position);   
ScanZ_hist                                  = max_z_hist-min_z_hist;  

imshow(imresize(images(:,:,j),[max(size(images(:,:,j))),max(size(images(:,:,j)))]),[min_z_hist,max_z_hist])                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max
                                                                                                                                                       
color_string                                = get(S.ColorBarSelect, 'string');
color_value                                 = get(S.ColorBarSelect, 'value');
switch color_string{color_value}                                                                                                                                                   
    case 'Autumn'                                                                                                                                                        
        colormap(autumn);
    case 'Bone'                                                                                                                                                        
        colormap(bone);
    case 'ColorCube'                                                                                                                                                        
        colormap(colorcube);
    case 'Cool'                                                                                                                                                        
        colormap(cool);
    case 'Copper'                                                                                                                                                        
        colormap(copper);
    case 'Flag'                                                                                                                                                        
        colormap(flag);
    case 'Gray'                                                                                                                                                        
        colormap(gray);
    case 'Hot'                                                                                                                                                        
        colormap(hot);
    case 'HSV'                                                                                                                                                        
        colormap(hsv);
    case 'Jet'                                                                                                                                                        
        colormap(jet);
    case 'Lines'                                                                                                                                                        
        colormap(lines);
    case 'Pink'                                                                                                                                                        
        colormap(pink);
    case 'Prism'                                                                                                                                                        
        colormap(prism);
    case 'Spring'                                                                                                                                                        
        colormap(spring);
    case 'Summer'                                                                                                                                                        
        colormap(summer);
    case 'Winter'                                                                                                                                                        
        colormap(winter);
    case 'Sky'
        load('Sky','mycmap_sky') 
        colormap(mycmap_sky);
    case 'NanoBrown'
        load('NanoBrown','mycmap_nanobrown') 
        colormap(mycmap_nanobrown);
end
                                                                                                                                                       % Sets the colormap 
    hcb = colorbar('YTick',min_z_hist:ScanZ_hist/10:max_z_hist,...
                  'YTickLabel',{            [num2str(min_z_hist+0*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Inserts a color bar.  Sets the 1st tick with approriate labels
                                            [num2str(min_z_hist+1*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 2nd tick with approriate labels
                                            [num2str(min_z_hist+2*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 3rd tick with approriate labels
                                            [num2str(min_z_hist+3*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 4th tick with approriate labels
                                            [num2str(min_z_hist+4*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 5th tick with approriate labels
                                            [num2str(min_z_hist+5*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 6th tick with approriate labels
                                            [num2str(min_z_hist+6*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 7th tick with approriate labels
                                            [num2str(min_z_hist+7*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],... 
                                            [num2str(min_z_hist+8*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],...  
                                            [num2str(min_z_hist+9*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 8th tick with approriate labels
                                            [num2str(min_z_hist+10*ScanZ_hist/10,'%0.2f'),' ', channel_info(j).Unit]});%,...                                                                  % Sets the 9th tick with approriate labels
                                            %'FontSize', FontSize, 'FontName', FontName);                                                                                            % Sets the font and size for the color bar
    set(hcb,'YTickMode','manual');%,'FontSize', FontSize, 'FontName', FontName);                                                                                                       % Apply the font to the colorbar


%This plots the integral scale bar.  It works...  It's not all my code.
DistFactor                                  = 0.05;                                                                                                                                 % Scalebar height
Length                                      = ScaleBar;                                                                                                                             % User set scalebar length
Pos                                         = [0.5*max(size(images(:,:,j))),0.95*max(size(images(:,:,j)))];                                                                         % positions scale bar
Scale                                       = ScanSize/(size(images,2)*(1+crop_fraction));                                                                                                              % Image scale
UnitsName                                   = ' nm';                                                                                                                                % Units for the scale bar
NextPlot                                    = get(gca,'NextPlot');                                                                                                              
hold on;

XLim                                        = get(gca,'XLim');
YLim                                        = get(gca,'YLim');
Xdiff                                       = abs(diff(XLim));
Ydiff                                       = abs(diff(YLim));

LineX                                       = Pos(1) + 0.5.*Length./Scale.*[-1;+1];
LineY                                       = Pos(2).*[+1;+1];
DistXdir                                    = 0;
DistYdir                                    = -1;


%--- plot line ---
plot(LineX,LineY,'w-','LineWidth',2);


%--- plot text ---
DistX                                       = DistXdir.*DistFactor.*Xdiff;
DistY                                       = DistYdir.*DistFactor.*Ydiff;

Htext                                       = text(Pos(1)+DistX,Pos(2)+DistY,sprintf('%5.1f %s',Length,UnitsName));
set(Htext,'HorizontalAlignment','center','Color', 'w');%, 'FontSize', FontSize, 'FontName', FontName);
set(gca,'XLim',XLim);
set(gca,'YLim',YLim);
set(gca,'NextPlot',NextPlot);
set(gca, 'XTickMode', 'manual');
hold off;